% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.input.form.R
\name{get.input.form}
\alias{get.input.form}
\title{Generate input format for os.jcdf()}
\usage{
get.input.form(
  datapath,
  evidence.matrix = F,
  gene.colname = c("symbol", "entrez_id"),
  statistics.colname = "P.Value",
  form = "order.rate",
  add.entrezid = T
)
}
\arguments{
\item{datapath}{:Path for storing multiple summary data or full path of a evidence matrix file.}

\item{evidence.matrix}{:Logical, whether to generate an evidence matrix, the default is "F":represents the datapath input is the path of multiple summary data storage, "T": represents the datapath input is the path of the statistical value matrix of multiple data.}

\item{gene.colname}{:Vector, column name of gene column.You can enter multiple gene identification columns, such as: c("symbol","entrez_id").}

\item{statistics.colname}{:Character, the column name of statistics value as the basis for sorting.}

\item{form}{:Character, choose the output data from."order.rate"：Represents the order rate matrix that converts the order into the [0,1] interval; "order": outputs the order matrix; "statistics list": the matrix of statistics selected as the basis for sorting.}

\item{add.entrezid}{:Logical. Whether to add entrezid, default T.}
}
\value{
return the input matrix of os.jcdf or organize a certain statistic of multiple data into a matrix.
}
\description{
This method is used to construct the input matrix of os.jcdf or organize a certain statistic of multiple data into a matrix. When the form parameter is selected as "order.rate", the output matrix can be directly used as the input matrix of os.jcdf.
}
\examples{
datapath="C:/data" #Path for storing multiple summary data
get.input.form(
datapath,
evidence.matrix= F,
gene.colname = c("symbol"),
statistics.colname = "P.Value",
form = "order.rate",
add.entrezid = T
)
}
