% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OS.JCDF.R
\name{os.jcdf}
\alias{os.jcdf}
\title{calculate the Q statistic and corresponding approximate P-value}
\usage{
os.jcdf(rankdata, wand.dim)
}
\arguments{
\item{rankdata}{: a vector or matrix of rank ratio}

\item{wand.dim}{: A number or a vector of numbers that tells the function which dimension you want to calculate the result.}
}
\value{
Return a list that the Q statistic and approximate p-value for the dimension in the parameter you entered. All dimensions are sorted by p-value.
}
\description{
This R package calculating Q-statistics and approximate p-values.
It was developed that can be used to integrate multiple order
lists of genes to generate new order results.

This R package is not requested to train gene sets to calculate
the correlation coefficient as the order rate, only needs the
matrix of order rate which is generated by the user,
so it is more flexible in use.
}
\examples{
data(example.data)#use simulated datasets.
q.matrix<- os.jcdf(data,ncol(data)) #calculate the Q statistic and corresponding approximate P-value in 1 to 20 dimension.
}
