### Calculate the Q statistic of a vector using the formula proposed by Aerts et al.
cal.V <- function(v, r){
  k = length(v)
  l_k = 1:k
  ones = (-1)**(l_k + 1)
  f = factorial(l_k)
  p = r ** l_k
  return(ones %*% (rev(v) * p / f))
}

cal.Q <- function(rank.vector){
  N = sum(!is.na(rank.vector))
  v = rep(1, N + 1)
  for(k in 1:N){
    v[k + 1] = cal.V(v[1:k],rank.vector[N - k + 1])
  }
  return(factorial(N) * v[N + 1])
}

Aerts.jcdf <- function(rank.vector){
  rank.vector<- sort(rank.vector, na.last = TRUE)
  return(cal.Q (rank.vector))
}

### Compute multidimensional Q statistics
join.Q<- function(rank,dim){
  q.result<- matrix(nrow = nrow(rank),ncol =length(dim))
  rownames(q.result) <- rownames(rank)
  colnames(q.result) <- str_c("N=",dim)
  for (j in 1:length(dim)){
    n=dim[j]
    print(str_c("Processing dimension=",n))
    m <-1:n
    for (i in 1:nrow(rank)) {
      if(is.na(sum(rank[i,m]))){
        q.result[i,j]<-NA
      }else{
        q.result[i,j]<- Aerts.jcdf(as.matrix(rank[i,m]))
      }
    }
  }
  return(q.result)
}

##Distribution fitting the Q statistic
fit.jcdf<- function(rankdata,q.matrix){
  data(beta.para30)
  data(gamma.para30)
  col.name<- colnames(q.matrix)
  row.name<- rownames(q.matrix)
  dim.input<- str_split(col.name,"N=",simplify = T)[,2] %>% as.numeric()
  result.list <- list()
  i <- 1
  for (x in dim.input) {
    if(x<=5){
      pval<- pbeta(q.matrix[,i],beta.para[1,x],beta.para[2,x])
    }else{
      pval<- pgamma(q.matrix[,i],gamma.para[1,x],gamma.para[2,x])
    }
    result<- data.frame(Q.statistics=q.matrix[,i],P.value=pval)
    result <- result[order(result$P.value),]
    result <-result%>%
      rownames_to_column("symbol:entrez_id") %>%
      separate(col=`symbol:entrez_id`,into = c("symbol","entrez_id"),sep = ":")
    result.list[[i]] <- result
    i <- i+1
  }
  names(result.list) <- col.name
  result.list[["input.data"]] <- rankdata
  return(result.list)
}



#' calculate the Q statistic and corresponding approximate P-value
#' @description
#'This R package calculating Q-statistics and approximate p-values.
#'It was developed that can be used to integrate multiple order
#'lists of genes to generate new order results.
#'
#'This R package is not requested to train gene sets to calculate
#'the correlation coefficient as the order rate, only needs the
#'matrix of order rate which is generated by the user,
#'so it is more flexible in use.
#' @param rankdata : a vector or matrix of rank ratio
#' @param wand.dim : A number or a vector of numbers that tells the function which dimension you want to calculate the result.
#'
#' @return Return a list that the Q statistic and approximate p-value for the dimension in the parameter you entered. All dimensions are sorted by p-value.
#' @export
#'
#' @examples
#' data(example.data)#use simulated datasets.
#' q.matrix<- os.jcdf(data,ncol(data)) #calculate the Q statistic and corresponding approximate P-value in 1 to 20 dimension.

os.jcdf<- function(rankdata,wand.dim){
  row.name<- rownames(rankdata)
  col.name <- colnames(rankdata)
  input.fit<- join.Q(rankdata,wand.dim)
  result<- fit.jcdf(rankdata,input.fit)
  return(result)
}


