
get.simulationData<- function(n,m,num.sig=0.01,num.top=0.09){
  out.rank<- data.frame(matrix(nrow = m,ncol = n))
  ##significant part
  sigtop.size <- floor(m*num.sig)
  sigtop.index<- sample(1:m,size=sigtop.size)
  ##important part
  top.size <- floor(m*num.top)
  top.index <- sample((1:m)[-sigtop.index],size = top.size)
  rownames(out.rank) <- str_c("gene",1:m)
  rownames(out.rank)[sigtop.index] <- str_c("gene",sigtop.index,"**")
  rownames(out.rank)[top.index] <- str_c("gene",top.index,"*")
  colnames(out.rank) <- str_c("object",1:ncol(out.rank))
  for (i in 1:n) {
    out.rank[sigtop.index,i] <- sample(1:sigtop.size,size=sigtop.size)
    out.rank[top.index,i] <- sample((1+sigtop.size):(sigtop.size+top.size),size = top.size)
    out.rank[is.na(out.rank[,i]),i] <- sample((1+sigtop.size+top.size):m,size = m-sigtop.size-top.size)
  }

  return(out.rank/m)
}

